package gov.va.med.mhv.usermgmt.persist.hibernate;

import gov.va.med.mhv.usermgmt.bizobj.FacilityInfoAssembler;
import gov.va.med.mhv.usermgmt.bizobj.FacilityInfoBO;
import gov.va.med.mhv.usermgmt.persist.FacilityInfoDao;
import gov.va.med.mhv.usermgmt.transfer.FacilityInfo;
import gov.va.med.mhv.usermgmt.transfer.Patient;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.tigris.atlas.persist.hibernate.DaoImpl;

import com.agitar.lib.ConcreteMock;
import com.agitar.lib.MockUtils;

public abstract class AgMockFacilityInfoDaoImpl extends DaoImpl implements
		ConcreteMock, FacilityInfoDao {
	public AgMockFacilityInfoDaoImpl() {
		MockUtils.doOriginal();
	}

	public String getEntityName() {
		return (String) MockUtils.getObject("java.lang.String");
	}

	public gov.va.med.mhv.usermgmt.bizobj.FacilityInfoBO saveFacilityInfo(
			org.tigris.atlas.validate.Validated validValues) {
		return (FacilityInfoBO) MockUtils.getObject(FacilityInfoBO.class
				.getName());
	}

	public gov.va.med.mhv.usermgmt.bizobj.FacilityInfoBO delete(
			gov.va.med.mhv.usermgmt.transfer.FacilityInfoPK pk) {
		return (FacilityInfoBO) MockUtils.getObject(FacilityInfoBO.class
				.getName());
	}

	public gov.va.med.mhv.usermgmt.bizobj.FacilityInfoBO findByPrimaryKey(
			gov.va.med.mhv.usermgmt.transfer.FacilityInfoPK pk) {
		return (FacilityInfoBO) MockUtils.getObject(FacilityInfoBO.class
				.getName());
	}

	public java.util.List queryByStationNumber(String stationNumber) {
		List list = (List) MockUtils.getObject(List.class.getName());
		boolean foundFacilityInfo = MockUtils.getRandom().nextBoolean();
		if (foundFacilityInfo) {
			try {
				FacilityInfoBO facilityInfo = (FacilityInfoBO) MockUtils
						.getObject(FacilityInfoBO.class.getName());
				list.add(facilityInfo);
			} catch (UnsupportedOperationException upe) {
				// do nothing - we don't care about this...
			}
		}
		return list;
	}

	public java.util.List queryByPatient(Patient patient) {
		return getRandomizedFacilityInfoBOList();
	}

	/**
	 * @return
	 */
	private List<FacilityInfoBO> getRandomizedFacilityInfoBOList() {
		List<FacilityInfoBO> list = new ArrayList<FacilityInfoBO>();
		boolean foundFacilityInfo = MockUtils.getRandom().nextBoolean();
		if (foundFacilityInfo) {
			try {
				FacilityInfoBO facilityInfo = (FacilityInfoBO)MockUtils.getObject(FacilityInfoBO.class.getName());
				list.add(facilityInfo);
			} catch (UnsupportedOperationException upe) {
				// do nothing - we don't care about this...
			}
		}
		return list;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.mhv.usermgmt.persist.FacilityInfoDao#getAllFacilityInfos()
	 */
	public List getAllFacilityInfos() {
		Collection<FacilityInfoBO> boCollection = getRandomizedFacilityInfoBOList();
		Collection toCollection = FacilityInfoAssembler.getFacilityInfoCollection(boCollection);
		List list = (List) MockUtils.getObject(List.class.getName());
		Iterator<FacilityInfoBO> i = boCollection.iterator();
		while (i.hasNext()) {
			list.add(i.next());
		}
		return list;
	}

	static {
		// if this block is left without any executable code, the compiler will
		// omit it
		// and the static initializer of the real class will be used
		MockUtils.doNothing();
	}

}
